<?php
/**
 * All function.
 *
 * @package SweetRice
 * @SweetRice core.
 * @since 0.5.4
 */
	defined('VALID_INCLUDE') or die();
	function do_data($a,$filterData){
		foreach($a as $key=>$val){
			if(!is_array($val)){
				switch($filterData){
					case 'public':
						$a[$key] = db_escape(trim(clean_quotes($val)));
					break;
					case 'privacy':
						$a[$key] = trim(clean_quotes($val));
					break;
				}
			}
		}
		return $a;
	}
	function escape_string($str){
		return htmlspecialchars(db_unescape($str),ENT_QUOTES);
	}
	function clean_quotes($str){
		if(get_magic_quotes_gpc()){
			$str = str_replace(array('\\\'','\\"','\\\\'),array('\'','"','\\'),$str);
		}
		return $str;
	}
	function db_escape($str){
		switch(DATABASE_TYPE){
			case 'sqlite':
				return sqlite_escape_string($str);
			break;
			case 'pgsql':
				return pg_escape_string($str);
			break;
			default:
				return mysql_escape_string($str);
		}
	}
	function db_unescape($str){
		switch(DATABASE_TYPE){
			case 'sqlite':
				return str_replace('\'\'','\'',$str);
			break;
			case 'pgsql':
				$str = str_replace(array('\\\'','\\"','\\\\'),array('\'','"','\\'),$str);
				return $str;
			break;
			default:
				$str = str_replace(array('\\\'','\\"','\\\\'),array('\'','"','\\'),$str);
				return $str;
		}
	}
	if (!function_exists('htmlspecialchars_decode')) {
		function htmlspecialchars_decode($str,$quote_style){
			$_str = array('&amp;','&quot;','&#039;','&lt;','&gt;');
			$str_ = array('&','"','\'','<','>');
			return str_replace($_str,$str_,$str);
		}
	}
	function initPermalinks(){
		$permalinks['attachment'] = 'download';
		$permalinks['rssfeed'] = 'rssfeed';
		$permalinks['rssfeedCat'] = 'cat_rssfeed';
		$permalinks['rssfeedPost'] = 'rssfeed';
		$permalinks['sitemapXml'] = 'sitemap';
		$permalinks['sitemapHtml'] = 'sitemap';
		$permalinks['comment'] = 'comment';
		$permalinks['plugin'] = 'plugin';
		$permalinks['tag'] = 'tags';
		$permalinks['ad'] = 'ads';
		$permalinks['u'] = 'u';
		return $permalinks;
	}
	//init Url data to SweetRice.
	function initUrl($url){
		global $permalinks;
		$urlRedirect = array();
		if(file_exists(ROOT_DIR.'inc/url_redirect.txt')){
			$redirect_contents = file(ROOT_DIR.'inc/url_redirect.txt');
			foreach($redirect_contents as $val){
				$val = trim($val);
				if($val){
					$tmp = explode('->',$val);
					$urlRedirect[trim($tmp[0])] = trim($tmp[1]);
				}
			}			
		}
		$url_data = array();
		if($urlRedirect[$url]){
			_301($urlRedirect[$url]);
		}elseif(preg_match("/^".$permalinks['attachment']."\/([0-9]+)\/$/",$url,$matches)){
			$url_data['action'] = 'attachment';
			$url_data['id'] = $matches[1];
		}elseif(preg_match("/^".$permalinks['ad']."\/([a-z0-9A-Z-_]+)\.js$/",$url,$matches)){
			$url_data['action'] = 'ads';
			$url_data['adname'] = $matches[1];
		}elseif($url==$permalinks['rssfeed'].'.xml'){
			$url_data['action'] = 'rssfeed';
		}elseif(preg_match("/^".$permalinks['rssfeedCat']."\/([a-zA-Z0-9\-_]+)\.xml$/",$url,$matches)){
			$url_data['action'] = 'rssfeed';
			$url_data['type'] = 'category';
			$url_data['c'] = $matches[1];
		}elseif(preg_match("/^".$permalinks['rssfeedPost']."\/([a-zA-Z0-9\-_]+)\.xml$/",$url,$matches)){
			$url_data['action'] = 'rssfeed';
			$url_data['type'] = 'entry';
			$url_data['post'] = $matches[1];
		}elseif($url==$permalinks['sitemapXml'].'.xml'){
			$url_data['action'] = 'sitemap';
			$url_data['type'] = 'xml';
		}elseif($url==$permalinks['sitemapHtml'].'/'){
			$url_data['action'] = 'sitemap';
		}elseif(preg_match("/^".$permalinks['comment']."\/([a-zA-Z0-9\-_]+)\/(([0-9]{0,3})\/)?$/",$url,$matches)){
			$url_data['action'] = 'comment';
			$url_data['post'] = $matches[1];
			$url_data['p'] = $matches[3];
		}elseif(preg_match("/^".$permalinks['tag']."\/([^\/]+)\/(([0-9]{0,3})\/)?$/",$url,$matches)){
			$url_data['action'] = 'tags';
			$url_data['tag'] = rawurldecode($matches[1]);
			$url_data['p'] = $matches[3];
		}elseif(preg_match("/^".$permalinks['u']."\/([^\/]+)\/$/",$url,$matches)){
			$url_data['action'] = 'pluginHook';
			$url_data['plugin'] = 'tmpto';
			$url_data['account'] = rawurldecode($matches[1]);
		}elseif(preg_match("/^([a-zA-Z0-9\-_]+)\.html$/",$url,$matches)){
			$url_data['action'] = 'entry';
			$url_data['post'] = $matches[1];
		}elseif(preg_match("/^([a-zA-Z0-9\-_]+)\/(([0-9]{0,3})\/)?$/",$url,$matches)){
			$url_data['action'] = 'category';
			$url_data['c'] = $matches[1];
			$url_data['p'] = $matches[3];
		}elseif(preg_match("/^([a-zA-Z0-9\-_]+)\/([a-zA-Z0-9\-_]+)\/$/",$url,$matches)){
			$url_data['action'] = 'entry';
			$url_data['cateName'] = $matches[1];
			$url_data['post'] = $matches[2];
		}elseif(substr($url,0,4)=='inc/'||substr($url,0,strlen(DASHBOARD_DIR)+5)==DASHBOARD_DIR.'/lib/'){
			$url_data['action'] = 'Forbidden';
		}elseif($url){
			$prefix = end(explode('/',$url));
			if(strpos($prefix,'.')){
				$url_data['rtype'] = 'wp';
			}else{
				$url_data['rtype'] = 'wop';
			}
			$url_data['action'] = 'Unknow';
		}
		return $url_data;
	}
	function show_link_ads($adname){
		global $global_setting;
		if($global_setting['url_rewrite']){
			global $permalinks;
			return $permalinks['ad'].'/'.$adname.'.js';
		}else{
			return '?action=ads&adname='.$adname;
		}
	}
	function show_link_page($cat_link,$post){
		global $global_setting;
		if($global_setting['url_rewrite']){
			if($cat_link){
				return $cat_link.'/'.$post.'/';
			}else{
				return $post.'.html';
			}
		}else{
			return '?action=entry&post='.$post;
		}
	}
	function show_link_page_xml($post){
		global $global_setting;
		if($global_setting['url_rewrite']){
			global $permalinks;
			return $permalinks['rssfeedPost'].'/'.$post.'.xml';
		}else{
			return '?action=rssfeed&type=entry&post='.$post;
		}
	}
	function show_link_cat($category,$p=''){
		global $global_setting;
		if($global_setting['url_rewrite']){
			return $category.'/'.($p>1?$p.'/':'');
		}else{
			return '?action=category&c='.$category.($p>1?'&p='.$p:'');
		}
	}
	function show_link_cat_xml($category){
		global $global_setting;
		if($global_setting['url_rewrite']){
			global $permalinks;
			return $permalinks['rssfeedCat'].'/'.$category.'.xml';
		}else{
			return '?action=rssfeed&type=category&c='.$category;
		}
	}
	function show_link_tag($tag){
		global $global_setting;
		if($global_setting['url_rewrite']){
			global $permalinks;
			return $permalinks['tag'].'/'.rawurlencode($tag).'/';
		}else{
			return '?action=tags&tag='.rawurlencode($tag);
		}
	}
	function show_link_comment($post,$p=false){
		global $global_setting;
		if($global_setting['url_rewrite']){
			global $permalinks;
			return $permalinks['comment'].'/'.$post.'/'.($p>1?$p.'/':'');
		}else{
			return '?action=comment&post='.$post.($p>1?'&p='.$p:'');
		}
	}
	function show_link_attachment($fileID){
		global $global_setting;
		global $permalinks;
		if($global_setting['url_rewrite']){
			return $permalinks['attachment'].'/'.$fileID.'/';
		}else{
			return '?action=attachment&id='.$fileID;
		}
	}
	function show_link_sitemapHtml(){
		global $global_setting;
		global $permalinks;
		if($global_setting['url_rewrite']){
			return $permalinks['sitemapHtml'].'/';
		}else{
			return '?action=sitemap';
		}
	}
	function show_link_sitemapXml(){
		global $global_setting;
		global $permalinks;
		if($global_setting['url_rewrite']){
			return $permalinks['sitemapXml'].'.xml';
		}else{
			return '?action=sitemap&type=xml';
		}
	}
	function show_link_rssfeed(){
		global $global_setting;
		global $permalinks;
		if($global_setting['url_rewrite']){
			return $permalinks['rssfeed'].'.xml';
		}else{
			return '?action=rssfeed';
		}
	}
	function postPreview($content){
		preg_match_all("/.*(<p ?.*>(.+)<\/p>)+.*/",$content,$matchs);
		foreach($matchs[1] as $key=>$val){
			if($val!='<p>&nbsp;</p>'&&$val!='<p></p>'){
				preg_match("/<p ?[^>]*>(.+)<\/p>/",$val,$out);
				$previewContent = $out[1];
				break;
			}
		}
		if(!$previewContent){
			$previewContent = mb_substr(strip_tags($content),0,300,'UTF-8');
		}
		return $previewContent;
	}
	if(!function_exists('mb_substr')){
		function mb_substr($str,$start,$len,$charcode){
			$str_len = strlen($str);
			$tmpstr = "";
			for($i = 0; $i < $start; $i++){
				 if(ord(substr($str, $i, 1)) > 127){
					 if(ord(substr($str, $i, 2)) > 127){
						$i += 2;
					 }else{
						$i++;
					 }					
				 }
			}
			$start = $i;
			$strlen = ($start + $len)>$str_len?$str_len:($start + $len);
			for($i = $start; $i < $strlen; $i++){
				 if(ord(substr($str, $i, 1)) > 127){
					 if(ord(substr($str, $i, 2)) > 127){
						$tmpstr .= substr($str, $i, 3);
						$i += 2;
					 }else{
						$tmpstr .= substr($str, $i, 2);
						$i++;
					 }					
				 }else
					$tmpstr .= substr($str, $i, 1);
			}
			return $tmpstr;
		}
	}
	function checkemail($email){
		$email = strtolower($email);
		return preg_match("/^[_\.0-9a-zA-Z-]+@([0-9a-zA-Z][0-9a-zA-Z-]*\.)+[a-zA-Z]{2,3}$/",$email);
	}
	function my_post($to,$subject,$mail_text,$mail_html,$from_mail,$from_name,$mime_boundary,$charset = 'UTF-8'){
		$from_name = '=?'.$charset.'?B?'.base64_encode($from_name).'?=';
		$subject = '=?'.$charset.'?B?'.base64_encode($subject).'?=';
		$headers = "From: ".$from_name." <".$from_mail.">\n";
		$headers .= "MIME-Version: 1.0\n";
		$headers .= "Content-Type: multipart/alternative; boundary=\"$mime_boundary\"\n";
		$message = "--$mime_boundary\n";
		$message .= "Content-Type: text/plain; charset=".$charset."\n";
		$message .= "Content-Transfer-Encoding: 8bit\n\n";
		$message .= $mail_text;
		$message .= "\n\n";
		$message .= "--$mime_boundary\n";
		$message .= "Content-Type: text/html; charset=".$charset."\n";
		$message .= "Content-Transfer-Encoding: 8bit\n\n";
		$message .= $mail_html;
		$message .= "\n";
		$message .= "--$mime_boundary--\n\n";
		$mail_sent = mail( $to, $subject, $message, $headers );
		return $mail_sent;
	}
	function js_unescape($str){
			$ret = '';
			$len = strlen($str);
			for ($i = 0; $i < $len; $i++){
					if ($str[$i] == '%' && $str[$i+1] == 'u'){
							$val = hexdec(substr($str, $i+2, 4));
							if ($val < 0x7f) $ret .= chr($val);
							else if($val < 0x800) $ret .= chr(0xc0|($val>>6)).chr(0x80|($val&0x3f));
							else $ret .= chr(0xe0|($val>>12)).chr(0x80|(($val>>6)&0x3f)).chr(0x80|($val&0x3f));
							$i += 5;
					}else if ($str[$i] == '%'){
							$ret .= urldecode(substr($str, $i, 3));
							$i += 2;
					}
					else $ret .= $str[$i];
			}
			return $ret;
	}
	function sweetrice_cache($cache_link,$data,$cache_type){
		global $global_setting;
		if($global_setting['cache']){
			if(!file_exists(ROOT_DIR.'inc/cache/')){
				mkdir(ROOT_DIR.'inc/cache/');
			}
			if(!file_exists(ROOT_DIR.'inc/cache/'.$cache_link)||(time()-filemtime(ROOT_DIR.'inc/cache/'.$cache_link)>$global_setting['cache_expired']&&$global_setting['cache_expired']!=0)){
				$cache_data = '';
				switch($cache_type){
					case 'db_array':
						if(is_array($data)){
								$cache_data .= serialize($data);				
						}
					break;
					case 'db_arrays':
						if(is_array($data)){
							$cache_data .= serialize($data);	
						}
					break;
					case 'db_total':
						$cache_data = $data;
					break;
				}
				file_put_contents(ROOT_DIR.'inc/cache/'.$cache_link,$cache_data);
				return ;
			}
		}else{
			return ;
		}
	}
	function sweetrice_cached($cache_link,$cache_type){
		global $global_setting;
		if($global_setting['cache']){
			if(file_exists(ROOT_DIR.'inc/cache/'.$cache_link)&&(time()-@filemtime(ROOT_DIR.'inc/cache/'.$cache_link)<=$global_setting['cache_expired']||$global_setting['cache_expired']==0)){
				$cache_data = file_get_contents(ROOT_DIR.'inc/cache/'.$cache_link);
				switch($cache_type){
					case 'db_array':
						return unserialize($cache_data);
					break;
					case 'db_arrays':
						return unserialize($cache_data);
					break;
					case 'db_total':
						return $cache_data;
					break;	
				}
			}else{
				return false;
			}
		}else{
			return false;
		}
	}
	function db_insert($table,$_id,$_key,$_val,$return_no=false,$database_type=false){
		$_id[1] = intval($_id[1]);
		if(!$database_type){
			$database_type = DATABASE_TYPE;
		}
		switch($database_type){
			case 'sqlite':
				$_key = '"'.implode('","',$_key).'"';
				$_val = "'".implode("','",$_val)."'";
				if($_id[0]&&$_id[1]>0){
					$sql = "REPLACE INTO \"".$table."\" (\"".$_id[0]."\",".$_key.")VALUES('".$_id[1]."',".$_val.")";
				}elseif($_id[0]){
					$sql = "REPLACE INTO \"".$table."\"(\"".$_id[0]."\",".$_key.")VALUES(NULL,".$_val.")";
				}else{
					$sql = "REPLACE INTO \"".$table."\"(".$_key.")VALUES(".$_val.")";
				}
				global $db;
				return sqlite_dbinsert($db,$sql,$_id[0]);
			break;
			case 'pgsql':
				global $global_setting;
				$global_setting['cache'] = false;
				if($_id[0]&&$_id[1]>0){
					$total = db_total("SELECT COUNT(*) FROM \"".$table."\" WHERE \"".$_id[0]."\" = '".$_id[1]."'");
					if($total==1){
						$_sql = " SET ";
						for($i=0; $i<count($_key); $i++){
							if($i==0){
								$_sql .= " \"".$_key[$i]."\" = '".$_val[$i]."' ";
							}else{
								$_sql .= " , \"".$_key[$i]."\" = '".$_val[$i]."' ";
							}
						}
						$sql = "UPDATE \"".$table."\" ".$_sql." WHERE \"".$_id[0]."\" = '".$_id[1]."'";
					}else{
						$_key = '"'.implode('","',$_key).'"';
						$_val = "'".implode("','",$_val)."'";
						$sql = "INSERT INTO \"".$table."\"(\"".$_id[0]."\",".$_key.")VALUES('".$_id[1]."',".$_val.")";	
					}
					pg_query($sql);
					return $_id[1];
				}else{
					$_key = '"'.implode('","',$_key).'"';
					$_val = "'".implode("','",$_val)."'";
					if($_id[0]){
						$last_id = db_array("SELECT \"".$_id[0]."\" FROM \"".$table."\" ORDER BY \"".$_id[0]."\" DESC LIMIT 1 ");
						$last_id = $last_id[$_id[0]] + 1;
						$sql = "INSERT INTO \"".$table."\"(\"".$_id[0]."\",".$_key.")VALUES('$last_id',".$_val.")";
					}else{
						$tindex = db_array("SELECT pg_constraint.conname AS pk_name,pg_attribute.attname AS colname FROM pg_constraint INNER JOIN pg_class ON pg_constraint.conrelid = pg_class.oid INNER JOIN pg_attribute ON pg_attribute.attrelid = pg_class.oid AND pg_attribute.attnum = pg_constraint.conkey[1] WHERE pg_class.relname = '".$table."' AND pg_constraint.contype='p'");
						if($tindex['colname']){
							$n_key = array_flip($_key);
							$nindex = $n_key[$tindex['colname']];
							$total = db_total("SELECT COUNT(*) FROM \"$table\" WHERE \"".$tindex['colname']."\" = '".$_val[$nindex]."'");
							if($total){
								$_sql = " SET ";
								for($i=0; $i<count($_key); $i++){
									if($i==0){
										$_sql .= " \"".$_key[$i]."\" = '".$_val[$i]."' ";
									}else{
										$_sql .= " , \"".$_key[$i]."\" = '".$_val[$i]."' ";
									}
								}
								$sql = "UPDATE \"".$table."\" ".$_sql." WHERE \"".$tindex['colname']."\" = '".$_val[$nindex]."'";
							}else{
								$sql = "INSERT INTO \"".$table."\"(".$_key.")VALUES(".$_val.")";
							}
						}else{
							$sql = "INSERT INTO \"".$table."\"(".$_key.")VALUES(".$_val.")";
						}
					}
					pg_query($sql);
					if(!$return_no&&$_id[0]){
						$row = db_array("SELECT \"".$_id[0]."\" FROM \"".$table."\" ORDER BY \"".$_id[0]."\" DESC LIMIT 1 ");
						return $row[$_id[0]];
					}else{
						return true;
					}
				}
			break;
			default:
				$_key = '`'.implode('`,`',$_key).'`';
				$_val = "'".implode("','",$_val)."'";
				if($_id[0]){
					$sql = "REPLACE INTO `".$table."`(`".$_id[0]."`,".$_key.")VALUES('".$_id[1]."',".$_val.")";
				}else{
					$sql = "REPLACE INTO `".$table."`(".$_key.")VALUES(".$_val.")";
				}
				mysql_query($sql);
				if($_id[0]){
					return mysql_insert_id();
				}else{
					return true;
				}
		}
	}
	function db_error(){
		switch(DATABASE_TYPE){
			case 'sqlite':
				global $sqlite_driver,$db;
				if($sqlite_driver=='sqlite'){
					return sqlite_error_string(sqlite_last_error($db));
				}else{
					$error = $db->errorInfo();
					if($error[0]!='0000'){
						return $error[2];
					}else{
						return '';
					}
				}
			break;
			case 'pgsql':
				return pg_last_error();
			break;
			default:
				return mysql_error();
		}
	}
	function db_query($sql){
		switch(DATABASE_TYPE){
			case 'sqlite':
				$sql = str_replace('`','"',$sql);
				global $db;
				return sqlite_dbquery($db,$sql);
			break;
			case 'pgsql':
				$sql = str_replace('`','"',$sql);
				$res = pg_query($sql);
				return pg_last_error();
			break;
			default:
				mysql_query($sql);
				return mysql_error();
		}
	}
	function db_arrays($sql,$type = 'ASSOC'){
		$cache_link = 'db_arrays_'.md5($sql);
		$cache_data = sweetrice_cached($cache_link,'db_arrays');
		if($cache_data){
			return $cache_data;
		}else{
			switch(DATABASE_TYPE){
				case 'sqlite':
					$sql = str_replace('`','"',$sql);
					global $db;
					$rows = sqlite_dbarrays($db,$sql,$type);
				break;
				case 'pgsql':
					$sql = str_replace('`','"',$sql);
					$res = pg_query($sql);
					while($row = pg_fetch_array($res,null,$type=='BOTH'?PGSQL_BOTH:PGSQL_ASSOC)){
						$rows[] = $row;
					}
				break;
				default:
					$res = mysql_query($sql);
					while($row = mysql_fetch_array($res,$type=='BOTH'?MYSQL_BOTH:MYSQL_ASSOC)){
						$rows[] = $row;
					}
			}
			sweetrice_cache($cache_link,$rows,'db_arrays');
			return is_array($rows)?$rows:array();
		}
	}
	function db_array($sql,$type = 'ASSOC'){
		$cache_link = 'db_array_'.md5($sql);
		$cache_data = sweetrice_cached($cache_link,'db_array');
		if($cache_data){
			return $cache_data;
		}else{
			switch(DATABASE_TYPE){
				case 'sqlite':
					$sql = str_replace('`','"',$sql);
					global $db;
					$row = sqlite_dbarray($db,$sql,$type);
				break;
				case 'pgsql':
					$sql = str_replace('`','"',$sql);
					$row = pg_fetch_array(pg_query($sql),null,$type=='BOTH'?PGSQL_BOTH:PGSQL_ASSOC);
				break;
				default:
					$row = mysql_fetch_array(mysql_query($sql),$type=='BOTH'?MYSQL_BOTH:MYSQL_ASSOC);
			}
			sweetrice_cache($cache_link,$row,'db_array');
			return is_array($row)?$row:array();
		}
	}
	function db_total($sql){
		$cache_link = 'db_total_'.md5($sql);
		$cache_data = sweetrice_cached($cache_link,'db_total');
		if($cache_data){
			return $cache_data;
		}else{
			switch(DATABASE_TYPE){
				case 'sqlite':
					$sql = str_replace('`','"',$sql);
					global $db;
					$total = sqlite_dbtotal($db,$sql);
				break;
				case 'pgsql':
					$sql = str_replace('`','"',$sql);
					$row = pg_fetch_row(pg_query($sql));
					$total = $row[0];
				break;
				default:
					$row = mysql_fetch_row(mysql_query($sql));
					$total = $row[0];
			}
			sweetrice_cache($cache_link,$total,'db_total');
			return $total;			
		}
	}
	function sqlite_dbhandle($dbname){
		global $sqlite_driver;
		if($sqlite_driver=='sqlite'){
			$db = sqlite_open($dbname);
		}else{
			if(!file_exists($dbname)){
				$handle = fopen($dbname,'w+');
				fclose($handle);
			}
			$db = new PDO('sqlite:'.$dbname);
		}
		return $db;
	}
	function sqlite_dbinsert($db,$sql,$id){
		global $sqlite_driver;
		if($sqlite_driver=='sqlite'){
			sqlite_query($db,$sql);
			if($id){
				return sqlite_last_insert_rowid($db);
			}else{
				return true;
			}
		}else{			
			$db->query($sql);
			if($id){
				return $db->lastInsertId();
			}else{
				return true;
			}
		}
	}
	function sqlite_dbquery($db,$sql){
		global $sqlite_driver;
		if($sqlite_driver=='sqlite'){
			sqlite_query($db,$sql,null,$error);
			if($error){
				return $error;
			}else{
				return '';
			}			
		}else{
			$db->query($sql);
			$error = $db->errorInfo();
			if($error[0]!='0000'){
				return $error[2];
			}else{
				return '';
			}
		}
	}
	function sqlite_dbarray($db,$sql,$type){
		global $sqlite_driver;
		if($sqlite_driver=='sqlite'){
			return clean_dbData(sqlite_fetch_array(sqlite_query($db,$sql),$type=='BOTH'?SQLITE_BOTH:SQLITE_ASSOC));
		}else{
			$row = $db->query($sql)->fetchAll($type=='BOTH'?SQLITE_BOTH:PDO::FETCH_ASSOC);
			return $row[0];
		}
	}
	function sqlite_dbarrays($db,$sql,$type=null){
		global $sqlite_driver;
		if($sqlite_driver=='sqlite'){
			$res = sqlite_query($db,$sql);
			while($row = sqlite_fetch_array($res,$type=='BOTH'?SQLITE_BOTH:SQLITE_ASSOC)){
				$rows[] = clean_dbData($row);
			}
		}else{
			$rows = $db->query($sql)->fetchAll($type=='BOTH'?SQLITE_BOTH:PDO::FETCH_ASSOC);
		}
		return $rows;
	}
	function sqlite_dbtotal($db,$sql){
		global $sqlite_driver;
		if($sqlite_driver=='sqlite'){
			$row = sqlite_fetch_array(sqlite_query($db,$sql));
			return $row[0];
		}else{
			$row = $db->query($sql)->fetchAll();
			$total = $row[0][0];	
			return $total;			
		}
	}
	function clean_dbData($row){
		if(!$row){
			$row = array();
		}
		foreach($row as $key=>$val){
			$row[trim($key,'"')] = $val;
		}
		return $row;
	}
	function db_list(){
		switch(DATABASE_TYPE){
			case 'sqlite':
					$table_array = db_arrays("select name from sqlite_master where name LIKE '".DB_LEFT.'_'."%' AND name NOT LIKE 'sqlite_%'",'BOTH');
					foreach($table_array as $val){
						if(substr($val[0],0,(strlen(DB_LEFT)+1))==DB_LEFT.'_'){
							$table_list[] = $val[0];
						}
					}
			break;
			case 'mysql':
					$table_array = db_arrays("SHOW TABLES",'BOTH');
					foreach($table_array as $val){
						if(substr($val[0],0,(strlen(DB_LEFT)+1))==DB_LEFT.'_'){
							$table_list[] = $val[0];
						}
					}
			break;
			case 'pgsql':
					$table_array = db_arrays("SELECT tablename FROM pg_tables  WHERE tablename LIKE '".DB_LEFT."_%' ;");
					foreach($table_array as $val){
						if(substr($val['tablename'],0,(strlen(DB_LEFT)+1))==DB_LEFT.'_'){
							$table_list[] = $val['tablename'];
						}
					}
			break;
		}
		return $table_list;
	}
	function _out(){
		if(!headers_sent()&&extension_loaded("zlib")&&strpos($_SERVER["HTTP_ACCEPT_ENCODING"],"gzip")!==false){
			ob_start(ob_start("ob_gzhandler"));
		}else{
			ob_start();
		}
	}
	function _flush(){
		ob_end_flush();
	}
	function upload_($f,$dest_dir,$new_file,$old_file){
		$file_type = '.php';
		$fileext = '.'.end(explode('.',$f['name']));
		if(preg_match("/[^a-zA-Z0-9_\-\.\s]+/",$new_file)){
			$new_file  = md5($new_file).$fileext;
		}
		if($f['name']&&strtolower($fileext)!=$file_type){
			$dest=$dest_dir.$new_file;
			$r=move_uploaded_file($f['tmp_name'],$dest);
			if($old_file&&file_exists($dest_dir.$old_file)&&$old_file!=$new_file){
				unlink($dest_dir.$old_file);
			}
			return $new_file;
		}else{
			return $old_file;
		}
	}
	function subCategory($sql='',$id=0,$level=0){
		$subCategorys = array();
		$row = db_arrays("SELECT `".DB_LEFT."_category`.`id` FROM `".DB_LEFT."_category` LEFT JOIN `".DB_LEFT."_item_plugin` ON `".DB_LEFT."_category`.`id` = `".DB_LEFT."_item_plugin`.`item_id` WHERE `".DB_LEFT."_category`.`parent_id` = '$id' AND `".DB_LEFT."_item_plugin`.`item_type` = 'category' ".$sql);
		
		foreach($row as $val){
			$val['level'] = $level;
			$subCategorys[] = $val;
			$subCategorys = array_merge ($subCategorys,subCategory($sql,$val['id'],$level+1));
		}
		return $subCategorys;
	}
	
	function mod_date($d){
		if(!$d){
			$d = time();
		}
		if(intval(phpversion())>=5){
			$mod_date = date('c',$d);
		}else{
			$mod_date = date('Y-m-d',$d).'T'.date('HisO',$d);
		}
		return $mod_date;
	}
	function init_browsers($t=1){
		$browsers = array('MSIE 10.0','MSIE 9.0','MSIE 8.0','MSIE 7.0','MSIE 6.0','Firefox','Opera','Chrome','Safari','Google','Yahoo','Bing','Baidu','Other');
		$bg_browsers = array('#2800fc','#2896fc','#286ea2','#285880','#0a9682','#ee7907','#e11625','#6aa0c8','#63b143','#009900','#ff11dd','#FF9900','#6655ff','#648282');
		if($t==2){
			return $bg_browsers;
		}else{
			return $browsers;
		}
	}
	function user_track(){
		$ip = getenv("REMOTE_ADDR");
		$user_from = $_SERVER["HTTP_REFERER"];
		$this_page = $_SERVER["REQUEST_URI"];
		$user_browser = $_SERVER["HTTP_USER_AGENT"];
		$browsers = init_browsers(1);
		foreach($browsers as $val){
			if(strpos(strtoupper($user_browser),strtoupper($val))!==false){
				$user_browser = $val;
				$is_browser = true;
				break;
			}
		}
		if(!$is_browser){
			$user_browser = 'Other';
		}
		
		if($user_from==''){
			$user_from = 'Directly access';
		}
		$dbname = 'inc/user_track.db';
		if(!file_exists($dbname)){
			$new_track = true;
		}
		$db_track = sqlite_dbhandle($dbname);
		if($new_track){
			sqlite_dbquery($db_track,"CREATE TABLE user_agent (id INTEGER PRIMARY KEY ,ip varchar(39) ,user_from varchar(255) ,this_page varchar(255),user_browser varchar(255),time integer)");
			sqlite_dbquery($db_track,"CREATE TABLE agent_month (id INTEGER PRIMARY KEY ,user_browser varchar(255),record_date date,total int(10),UNIQUE(user_browser,record_date))");
		}
		sqlite_dbquery($db_track,"INSERT INTO user_agent (id,ip,user_from,this_page,user_browser,time)VALUES(NULL,'$ip','$user_from','$this_page','$user_browser','".time()."')");
		return ;
	}
	function get_limit_sql($page_start,$page_limit){
		if(DATABASE_TYPE=='pgsql'){
			return "LIMIT $page_limit OFFSET $page_start";
		}else{
			return "LIMIT $page_start , $page_limit ";
		}
	}
	function get_page_themes(){
		$theme = file(ROOT_DIR.(THEME_DIR?THEME_DIR:'inc/').'theme.config');
		foreach($theme as $key=>$val){
			if(trim($val)){
				$tmp = explode('|',$val);
				$page_theme[trim($tmp[0])] = trim($tmp[1]);
			}
		}
		return $page_theme;
	}
 function filesize2print($filename){
		if(substr($filename,0,strlen(BASE_URL))!=BASE_URL){
			return 'Remote file';
		}
		$filename = str_replace(BASE_URL,ROOT_DIR,$filename);
		if(!file_exists($filename)){
			return 'Missing file';
		}
		$fs = filesize($filename);
		if($fs>1073741824){
			return number_format(($fs/1073741824),2,'.','').'G';
		}elseif($fs>1048576){
			return number_format(($fs/1048576),2,'.','').'M';
		}elseif($fs>1024){
			return number_format(($fs/1024),2,'.','').'k';
		}else{
			return $fs.'B';
		}
	}
	function filterXMLContent($content){
		$content = preg_replace("/[(\\x00-\\x08)(\\x0b-\\x0c)(\\x0e-\\x1f)]*/",'',$content);
		return $content;
	}
	function _404($tip_404){
		global $global_setting;
		header('HTTP/1.1 404 Page Not Found');
		$tip_404s = array('category'=>'Sorry ,the category does not exists.','entry'=>'Sorry ,the entry does not exists.','attachment'=>'Sorry ,the attachment does not exists.','tags'=>'Sorry ,the tag does not exists.','plugin'=>'Sorry ,the plugin does not exists.','home'=>'Invalid request,please check your url.');
		include("inc/404.php");
		exit();
	}
	function getLangTypes(){
		$d = dir(LANG_DIR);
		while (false !== ($entry = $d->read())) {
			 if($entry!='.'&&$entry!='..'&&!is_dir(LANG_DIR.$entry)){
				 preg_match("/\* (.+) language file/",file_get_contents(LANG_DIR.$entry),$matches);
				$lang_types[basename($entry,'.php')] = $matches[1];
			 }
		}
		$d->close();
		return $lang_types;
	}
	function _403(){
		header("HTTP/1.1 403 Forbidden"); 
		die('<!DOCTYPE html>
<html><head>
<title>403 Forbidden</title>
</head><body>
<h1>Access Forbidden</h1>
<p>You don\'t have permission to access this page.</p>
</body></html>');
	}
	function _301($url){
		header('HTTP/1.1 301 Moved Permanently'); 
		header('Location: '.$url); 
		exit();
	}
	function _304($last_access,$etag,$Expires){
		header('Cache-Control: public,must-revalidate');
		header('Expires: '.gmdate('D, d M Y H:i:s', $Expires).' GMT');
		header('Last-Modified:'.gmdate('D, d M Y H:i:s', $last_access).' GMT', true, 304);
		if($etag){
			header('Etag:'.$etag,true,304);
		}
		exit(0);
	}
	function _200($last_modify,$etag,$Expires){
		header('Cache-Control: public,must-revalidate');
		header('Expires: '.gmdate('D, d M Y H:i:s', $Expires).' GMT');
		header('Last-Modified: '.gmdate('D, d M Y H:i:s', $last_modify).' GMT', true, 200);
		if($etag){
			header('Etag:'.$etag,true,200);
		}
	}
	function outputHeader($last_modify,$etag='',$ExpiresDate=0){
		global $global_setting;
		$last_access = $_SERVER['HTTP_IF_MODIFIED_SINCE']?strtotime($_SERVER['HTTP_IF_MODIFIED_SINCE']):0;
		$last_etag = $_SERVER['HTTP_IF_NONE_MATCH'];
		$Expires = $last_modify + $ExpiresDate;
		$Expires = $Expires > time()?$Expires:time();
		$last_modify = max($last_modify,$_COOKIE["lang_update"],$global_setting['last_setting']);
		if($etag&&$last_etag!=$etag){
			_200($last_modify,$etag,$Expires);
		}elseif(($last_modify>0&&$last_modify <= $last_access)||($etag&&$last_etag==$etag)){
			_304($last_access,$etag,$Expires);
		}else{
			_200($last_modify,$etag,$Expires);
		}
	}
	function pushDate($row){
		$last_modifys = array(0);
		foreach($row as $val){
			foreach($val as $v){
				$last_modifys[] = $v['date'];
			}
		}
		return max($last_modifys);
	}

	function isPluginInstall($plugin){
		if($plugin&&file_exists(ROOT_DIR.'_plugin/'.$plugin.'/install.lock')){
			return true;
		}else{
			return false;
		}
	}

	function themeLang(){
		global $global_setting;
		$lang = $_COOKIE["lang"]?$_COOKIE["lang"]:$global_setting['theme_lang'];
		if(!$lang){
			$ltmp = explode(',',$_SERVER["HTTP_ACCEPT_LANGUAGE"]);
			switch(strtolower($ltmp[0])){
				case 'zh-cn':
					$lang = 'zh-cn';
				break;
				case 'en-us':
					$lang = 'en-us';
				break;
				default:
					if(strpos($ltmp[0],'zh-')){
						$lang = 'big5';
					}else{
						$lang = 'en-us';
					}
			}
		}
		return $lang;
	}

	function pluginApi($plugin,$apiFunction,$apiReturn=false){
		if(!$plugin||!$apiFunction||!isPluginInstall($plugin)){return false;}
			if(file_exists(ROOT_DIR.'_plugin/'.$plugin.'/shareFunction.php')){
				require_once(ROOT_DIR.'_plugin/'.$plugin.'/shareFunction.php');
				switch($apiReturn){
					case 'data':
						echo call_user_func($apiFunction);
					break;
					default:
						return call_user_func($apiFunction);
				}
			}else{
				return false;
			}
	}

	function pluginHook($plugin){
		if(!$plugin||!isPluginInstall($plugin)){return false;}
		if(file_exists(ROOT_DIR.'_plugin/'.$plugin.'/index.php')){
			return ROOT_DIR.'_plugin/'.$plugin.'/index.php';
		}else{
			return false;
		}
	}

	function pluginHookUrl($plugin,$args=array()){
		if(!isPluginInstall($plugin)){
			return false;
		}
		if(is_array($args)){
			foreach($args as $key=>$val){
				$str .= '&'.$key.'='.$val;
			}
		}
		return '?pluginQuery='.base64_encode('action=pluginHook&plugin='.$plugin.$str);
	}

	function pager($total,$page_limit,$p_link){
		global $global_setting;
		$page = max(1,intval($_GET["p"]));
		if(!$page_limit){
			$page_limit = 15;
		}
		
		$page_total = ceil($total/$page_limit);
		if($page>$page_total&&$page_total){
			$outPage = true;
		}else{
			$outPage = false;
		}
		$page_start = ($page-1)*$page_limit;
		$page_last = $page_total - $page;
		
		$list_put = '';
		if($page_total<=10){
			for($i=1; $i<=$page_total; $i++){
				$tmp_link = $i>1?($global_setting['url_rewrite']?$p_link.$i:$p_link.'&p='.$i):$p_link;
				$list_put .= "<a href=\"".$tmp_link.($global_setting['url_rewrite']&&$i!=1?'/':'')."\" ".($i==$page?'class="pageCurrent"':'').">".$i."</a> ";
			}
		}elseif($page == 1){
			$p_end = 0;
			for($i=0; $i<($page_last>10?10:$page_last); $i++){
				$tmp_link = $i>0?($global_setting['url_rewrite']?$p_link.($i+1):$p_link.'&p='.($i+1)):$p_link;
				$list_put .= "<a href=\"".$tmp_link.($global_setting['url_rewrite']&&$i>0?'/':'')."\" ".($i==0?'class="pageCurrent"':'').">".($i+1)."</a> ";
				$p_end +=1;
			}
			$list_put .= $page_last>=10?("<a href=\"".($global_setting['url_rewrite']?$p_link.'2':$p_link.'&p=2').($global_setting['url_rewrite']?'/':'')."\">Next&raquo;</a>"):'';
		}elseif($page == $page_total){
			$list_put .= "<a href=\"".($global_setting['url_rewrite']?$p_link.($page_total-1):$p_link.'&p='.($page_total-1)).($global_setting['url_rewrite']&&$page_total>11?'/':'')."\"/>&laquo;Previous</a> ";
			for($i=$page_total-9; $i<=$page_total; $i++){
				$tmp_link = $i>1?($global_setting['url_rewrite']?$p_link.$i:$p_link.'&p='.$i):$p_link;
				$list_put .= "<a href=\"".$tmp_link.($global_setting['url_rewrite']&&$i>1?'/':'')."\" ".($i==$page_total?'class="pageCurrent"':'').">".$i."</a> ";
			}
		}elseif($page > 1 && $page < $page_total){
			$p_end = $page-1;
			$list_put .= "<a href=\"".($page>2?($global_setting['url_rewrite']?$p_link.($page-1):$p_link.'&p='.($page-1)):$p_link).($global_setting['url_rewrite']&&$page>2?'/':'')."\"/>&laquo;Previous</a> ";
			if($page_last<10){
				for($i=10-$page_last; $i>0; $i--){
					$tmp_link = $page-$i>1?($global_setting['url_rewrite']?$p_link.($page-$i):$p_link.'&p='.($page-$i)):$p_link;
					$list_put .= "<a href=\"".$tmp_link.($global_setting['url_rewrite']&&($page-$i)>1?'/':'')."\" ".($i==0?'class="pageCurrent"':'').">".($page-$i)."</a> ";
				}		
			}
			for($i=0; $i<($page_last>10?10:$page_last); $i++){
				$tmp_link = $page+$i>1?($global_setting['url_rewrite']?$p_link.($page+$i):$p_link.'&p='.($page+$i)):$p_link;
				$list_put .= "<a href=\"".$tmp_link.($global_setting['url_rewrite']&&($page+$i)>1?'/':'')."\" ".($i==0?'class="pageCurrent"':'').">".($page+$i)."</a> ";
				$p_end += 1;
			}
			$list_put .= "<a href=\"".($global_setting['url_rewrite']?$p_link.($page+1):$p_link.'&p='.($page+1)).($global_setting['url_rewrite']?'/':'')."\">Next&raquo;</a>";
		}
		if($page_total>1){
			$list_put = $list_put?'<div id="PageList">'.$list_put.'</div>':'';
		}else{
			$list_put = '';
		}
		return array('page_start'=>$page_start,'list_put'=>$list_put,'outPage'=>$outPage,'page'=>$page);
	}
/*
Post insert
*/

	function post_insert($data=array(),$without_attachment=false){
		if(!$data){
			$data = $_POST;
		}
		$id = intval($data["id"]);
		$name = $data["name"];
		if(!$name){return false;}
		$title = $data["title"];
		$old_link = array('src="../'.ATTACHMENT_DIR,'data="../'.ATTACHMENT_DIR,'value="../'.ATTACHMENT_DIR);
		$new_link = array('src="'.ATTACHMENT_DIR,'data="'.ATTACHMENT_DIR,'value="'.ATTACHMENT_DIR);
		$info = str_replace($old_link,$new_link,$data["info"]);
		$info = db_escape($info);
		$keyword = $data["keyword"];
		$tags = explode(',',$data["tags"]);
		$taglist = array();
		foreach($tags as $val){
			$val = trim($val);
			if($val&&!in_array($val,$taglist)){
				$taglist[] = $val;
			}
		}
		$tags = implode(',',$taglist);
		$description = $data["description"];
		$sys_name = $data["sys_name"];
		$category = intval($data["category"]);
		$views = intval($data["views"]);
		$createTime = intval($data["createTime"]);
		$in_blog = intval($data["in_blog"]);
		$allow_comment = intval($data["allow_comment"]);
		$template = $data["template"];
		if($data["republish"]){
			$createTime = 0;
		}else{
			$createTime = intval($data["createTime"]);
		}
		if($sys_name){
			$sysname_total = db_total("SELECT COUNT(*) FROM `".DB_LEFT."_posts` WHERE `sys_name` = '$sys_name' and `id` !='$id' ");
			if($sysname_total!=0){
				$sys_name = time();
			}
		}else{
			$sys_name = time();
		}
		$post_id = db_insert(DB_LEFT."_posts",array('id',$id),array( 'name','title' , 'body' ,'keyword' ,'tags','description' , 'sys_name' ,'date' , 'category' ,'in_blog','views','allow_comment','template'),array(escape_string($name), escape_string($title), $info,escape_string($keyword),db_escape($tags),escape_string($description),$sys_name,($createTime?$createTime:time()), $category ,$in_blog,$views,$allow_comment,$template));
		if($id>0){
			db_query("UPDATE `".DB_LEFT."_comment` SET `post_cat` = '".$categories[$category]['link']."',`post_slug` = '$sys_name' WHERE `post_id` = '$post_id'");
		}else{
			db_insert(DB_LEFT."_item_plugin",array('id',''),array('item_id','item_type','plugin'),array($post_id,'post',$data['plugin']));
		}
		if(!$without_attachment){
			$attNos = $data["no"];
			for($i=1;$i<=$attNos;$i++){
				$attid = intval($data["attid_".$i]);			
				if($data["delatt_".$i]){
					if($attid>0){
						db_query("DELETE FROM `".DB_LEFT."_attachment` WHERE `post_id` = '$post_id' AND `id` = '$attid'");
					}
				}elseif($data['att_'.$i]){
					db_insert(DB_LEFT."_attachment",array('id',$attid),array('post_id','file_name','date','downloads'),array($post_id,$data['att_'.$i],$data["attdate_".$i]?intval($data["attdate_".$i]):time(),intval($data["atttimes_".$i])));
				}				
			}		
		}
		return array('post_id'=>$post_id,'sys_name'=>$sys_name);
	}

/*
	Category insert
*/
	function category_insert($data=array()){
		if(!$data){
			$data = $_POST;
		}
		if(!$data["name"]){return false;}
		$id = intval($data["id"]);
		$sys_name = strtolower($data["link"]);
		if($sys_name){
			$sysname_total = db_total("SELECT COUNT(*) FROM `".DB_LEFT."_category` WHERE `link` = '$sys_name' and `id` !='$id' ");
			if($sysname_total>0){
				$sys_name = time();
			}
		}else{
			$sys_name = time();
		}
		$cat_id = db_insert(DB_LEFT.'_category',array('id',$id),array('name' , 'link' , 'title' , 'description' , 'keyword' , 'sort_word','parent_id','template'),array(escape_string($data["name"]), $sys_name, escape_string($data["title"]), escape_string($data["description"]), escape_string($data["keyword"]), escape_string($data["sort_word"]), intval($data["parent_id"]),$data["template"]));
		$rows = db_arrays("SELECT * FROM `".DB_LEFT."_category`");
		db_query("UPDATE `".DB_LEFT."_options` SET `content` = '".db_escape(serialize($rows))."',`date` = '".time()."' WHERE `name` = 'categories'");
		if($id==0){
			db_insert(DB_LEFT.'_item_plugin',array('id',''),array('item_id','item_type','plugin'),array($cat_id,'category',$data['plugin']));
		}
		return array('cat_id'=>$cat_id,'sys_name'=>$sys_name);
	}

	function output_json($result){
		exit(json_encode($result));
	}
	function _posts($row,$post_output_template = false){
		global $categories;
		if(!is_array($row)){
			return ;
		}
		$tags = explode(',',$row['tags']);	
		foreach($tags as $key=>$val){
			if(trim($val)){
				$tag_str .= '<a href="'.show_link_tag($val).'">'.$val.'</a> ';
			}
		}
		if($post_output_template&&file_exists($post_output_template)){
			ob_start();
			include($post_output_template);	
			$content = ob_get_contents();
			ob_clean();
			return $content;
		}else{
			return '<div class="blog_text"><h2 class="blog_title"><a href="'.show_link_page($categories[$row['category']]['link'],$row['sys_name']).'">'.$row['name'].'</a></h2><div class="post_info"><div class="list_info"><p class="list_date">'.date('F,jS Y',$row['date']).'</p><p class="list_views">'.$row['views'].' '.VIEWS.'</p><p class="div_clear"></p></div>'.postPreview($row['body']).' <span title="'.BASE_URL.show_link_page($categories[$row['category']]['link'],$row['sys_name']).'" class="readmore">'.READ_MORE.'</span></div><p>'.TAGS.' '.$tag_str.'</p></div>';			
		}
	}
	function _comment($val,$k,$last_no,$comment_link,$comment_output_template = false){
		if(!is_array($val)){
			return ;
		}
		if($comment_output_template&&file_exists($comment_output_template)){
			ob_start();
			include($comment_output_template);	
			$content = ob_get_contents();
			ob_clean();
			return $content;
		}else{
			return '<fieldset><legend><a name="comment_'.$k.'"></a><a href="'.$comment_link.'#comment_'.$k.'">#'.$last_no.'</a> '.($val['website']?'<a href="'.$val['website'].'" rel="external nofollow">'.$val['name'].'</a>':$val['name']).' '.date('M,d,Y D',$val['date']).'</legend>'.$val['info'].'</dd></fieldset>';			
		}
	}
	function pluginList(){
		$plugin_list = array();
		$d = dir(ROOT_DIR."_plugin/");
		while (false !== ($entry = $d->read())) {
			if($entry !='.' && $entry !='..' && file_exists(ROOT_DIR.'_plugin/'.$entry.'/plugin_config.php')){
				$plugin_config = array();
				if(file_exists(ROOT_DIR.'_plugin/'.$entry.'/install.lock')){
					$plugin_config['installed'] = true;
				}
				if(file_exists(ROOT_DIR.'_plugin/'.$entry.'/plugin_config.php')){
					include(ROOT_DIR.'_plugin/'.$entry.'/plugin_config.php');
				}
				$plugin_config['directory'] = $entry;
				$plugin_list[$plugin_config['name']] = $plugin_config;		
			}
		}
		return $plugin_list;
	}

	function get_data_from_url($url){
		if(extension_loaded('curl')){
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL,$url);
			curl_setopt($ch, CURLOPT_VERBOSE, 1);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION,true);
			curl_setopt($ch, CURLOPT_MAXREDIRS,10);
			curl_setopt($ch, CURLOPT_TIMEOUT,120);
			$response = curl_exec_follow($ch,10);
			curl_close($ch);
			return $response;			
		}elseif(ini_get('allow_url_fopen')){
			return $output = file_get_contents($url);
		}else{
			fsockopen_follow($url);
		}
	}

	function curl_exec_follow($ch,$maxredirect) {
    $mr = max(5,intval($maxredirect));
    if (ini_get('open_basedir') == '' && ini_get('safe_mode' == 'Off')) {
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, $mr > 0);
        curl_setopt($ch, CURLOPT_MAXREDIRS, $mr);
    } else {
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false);
        if ($mr > 0) {
            $newurl = curl_getinfo($ch, CURLINFO_EFFECTIVE_URL);
            $rch = curl_copy_handle($ch);
            curl_setopt($rch, CURLOPT_HEADER, true);
            curl_setopt($rch, CURLOPT_NOBODY, true);
            curl_setopt($rch, CURLOPT_FORBID_REUSE, false);
            curl_setopt($rch, CURLOPT_RETURNTRANSFER, true);
            do {
                curl_setopt($rch, CURLOPT_URL, $newurl);
                $header = curl_exec($rch);
                if (curl_errno($rch)) {
                    $code = 0;
                } else {
                    $code = curl_getinfo($rch, CURLINFO_HTTP_CODE);
                    if ($code == 301 || $code == 302) {
                        preg_match('/Location:(.*?)\n/i', $header, $matches);
                        $newurl = trim(array_pop($matches));
                    } else {
                        $code = 0;
                    }
                }
            } while ($code && --$mr);
            curl_close($rch);
						if($newurl){
							curl_setopt($ch, CURLOPT_URL, $newurl);
						}else{
							return false;
						}
        }
    }
    return curl_exec($ch);
	} 

	function fsockopen_follow($url,$mr=5,$cr=0){
			if($cr >= $mr){
				return false;
			}else{
				$cr += 1;
			}
			$url = str_replace('http://','',$url);
			$urls = explode('/',$url);
			$url_str = substr($url,strlen($urls[0]));
			$fp = fsockopen($urls[0], 80, $errno, $errstr, 120);
			if (!$fp) {
					echo "$errstr ($errno)<br />\n";
			} else {
					$out = "GET ".$url_str." HTTP/1.1\r\n";
					$out .= "Host: ".$urls[0]."\r\n";
					$out .= "Connection: Close\r\n\r\n";
					fwrite($fp, $out);
					while (!feof($fp)) {
							$data .= fgets($fp, 1024);
					}
					fclose($fp);
			}
			if(preg_match("|HTTP/1.1\s302.*\n|i", $data)||preg_match("|HTTP/1.1\s301.*\n|i", $data)){
				preg_match('/Location:(.*?)\n/i', $data, $matches);
        $newurl = trim(array_pop($matches));
				return fsockopen_follow($newurl,$mr,$cr);
			}else{
				preg_match("/\r\n\r\n(.+)/is", $data, $out);
				$output = $out[1];
				return $output;
			}
	}

	function alert($str){
?>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<script type="text/javascript">
<!--
	alert('<?php echo $str;?>');
//-->
</script>
<?php
	}
	function _goto($url){
?>
<script type="text/javascript">
<!--
	location.href = '<?php echo $url;?>';
//-->
</script>
<?php
	exit();
	}
?>